package com.elitesland.srm.supplier.register.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.iam.service.IamUserService;
import com.elitesland.srm.supplier.biz.service.SuppValidateService;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.register.convert.SuppRegisterConvert;
import com.elitesland.srm.supplier.register.vo.save.SuppRegisterSaveParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class SupplierRegisterServiceImpl implements SupplierRegisterService<SuppRegisterSaveParam> {

    private final SuppValidateService validateService;
    private final IamUserService iamUserService;

    @Override
    public long registerSupp(SuppRegisterSaveParam saveParam) {
        // 注册校验
        validateService.registerValidate(saveParam);
        // 创建账号
        SuppSaveParam suppSaveParam = SuppRegisterConvert.INSTANCE.registerToSaveParam(saveParam);
        return iamUserService.createSuppUser(suppSaveParam);
    }
}
