package com.elitesland.srm.supplier.register.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 供应商名录联系人表的保存参数对象
 *
 * @author eric.hao
 * @since 2022/03/23
 */
@ApiModel(description = "供应商联系人表的保存参数对象")
@Data
public class SrmAddrAddressSaveParam implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "业务联系人姓名", required = true)
    private String contPerson;

    @ApiModelProperty(value = "业务联系人手机号", required = true)
    private String mobile;

    @ApiModelProperty(value = "业务联系人邮箱")
    private String email;

    @ApiModelProperty(value = "身份证号")
    private String es4;

    @ApiModelProperty(value = "意向区域(中文拼接)", required = true)
    private String es2;

    @ApiModelProperty(value = "意向区域(udc拼接)", required = true)
    private String es2Udc;

    @ApiModelProperty(value = "产品大类(中文拼接)", required = true)
    private String es1;

    @ApiModelProperty(value = "产品大类(udc拼接)", required = true)
    private String es1Udc;

    @ApiModelProperty(value = "意向省份(中文拼接)")
    private String es3;

    @ApiModelProperty(value = "意向省份(udc拼接)")
    private String es3Udc;

    @ApiModelProperty(value = "代理权权限", required = true)
    private String es6;

    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 手机号
     */
    private String es9;

    /**
     * 临时email
     */
    private String tempEmail;

    /**
     * 密码
     */
    private String password;
}
