package com.elitesland.yst.common.annotation.context.spi;

import org.springframework.context.annotation.Primary;

import java.lang.annotation.*;

/**
 * SPI 接口的注解.
 * <p>
 * 用于扩展SPI接口的功能，按需使用
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/17
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Spi {

    /**
     * 默认实现类
     * <p>
     * 优先级大于实现类上的注解{@link Primary}
     *
     * @return 类的全量名称
     */
    String primary() default "";
}
