package com.elitesland.yst.common.exception.handler;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * 异常相关配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/29
 */
@ConfigurationProperties(prefix = CloudtExceptionProperties.CONFIG_PREFIX)
public class CloudtExceptionProperties {
    public static final String CONFIG_PREFIX = "elitesland.cloudt.exception";

    private final GlobalException global = new GlobalException();

    public GlobalException getGlobal() {
        return global;
    }

    public static class GlobalException {
        /**
         * 消息格式，{appName}标识系统名称，{errorNo}标识错误号
         */
        private String defaultMsgFormat = "{appName}出现异常, 错误号：{errorNo}";

        /**
         * 应用信息
         */
        private List<AppInfo> appInfos = new ArrayList<>();

        public String getDefaultMsgFormat() {
            return defaultMsgFormat;
        }

        public void setDefaultMsgFormat(String defaultMsgFormat) {
            this.defaultMsgFormat = defaultMsgFormat;
        }

        public List<AppInfo> getAppInfos() {
            return appInfos;
        }

        public void setAppInfos(List<AppInfo> appInfos) {
            this.appInfos = appInfos;
        }
    }

    public static class AppInfo {
        /**
         * 应用编码，如yst-system
         */
        private String appCode;
        /**
         * 应用名称，如系统域
         */
        private String appName;

        public String getAppCode() {
            return appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public String getAppName() {
            return appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }
}
