package com.elitesland.yst.common.util.noifutils;

import java.util.function.Consumer;

/**
 * <p>
 *
 * <p>
 *
 * @author Roman.Zhang
 * @date 2021/12/11
 */
@FunctionalInterface
public interface PresentOrElseHandlerFunction<T extends Object> {
    /**
     * 值不为空时执行消费操作
     * 值为空时执行其他的操作
     *
     * @param action 值不为空时，执行的消费操作
     * @param emptyAction 值为空时，执行的操作
     * @return void
     **/
    void presentOrElseHandle(Consumer<? super T> action, Runnable emptyAction);
}
