package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * 功能说明 实体类:demo表
 *
 * @author meng
 * @date 2022-04-12 19:10:59
 */
@Data
@ApiModel(value = " yst_itm_item ", description = "商品表")
public class SrmItmItemNParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 1599378593498193109L;
    /**
     * 记录唯一ID
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("商品SKU ID列表")
    private List<Long> itemIds;
    @ApiModelProperty("商品SKU编号列表")
    private List<String> itemCodes;
    private String itemCode;
    @ApiModelProperty("itemcode2")
    private List<String> itemCodes2;
    private String itemCode2;
    @ApiModelProperty("商品品牌编号列表")
    private List<String> brands;
    @ApiModelProperty("品类编号")
    private String itemCateCode;

}
