package com.elitesland.support.provider.item.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 简单的物料信息实体类
 *
 * @Author: ryan.xu
 * @since 2022/11/15
 */
@ApiModel("公共物料查询实体")
@Data
public class CommonItmItemDTO implements Serializable {

    private static final long serialVersionUID = -2433824214121179055L;

    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "品项编号")
    private String itemCode;

    @ApiModelProperty(value = "第二编号")
    private String itemCode2;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("说明2")
    private String itemName2;

    @ApiModelProperty("说明3")
    private String itemDesc;

    @ApiModelProperty("主计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("牙别")
    private String tooth;

    @ApiModelProperty("材质")
    private String material;

    @ApiModelProperty("直径")
    private String diameter;

    @ApiModelProperty(value = "标准")
    private String standard;

    @ApiModelProperty("长度")
    private String lengths;

    private String spec;

    @ApiModelProperty("计量单位2")
    private String uom2;

    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("大类编号")
    private String c1Code;

    @ApiModelProperty("中类编号")
    private String c2Code;

    private String c2Name;

    @ApiModelProperty("小类编号")
    private String c3Code;

    @ApiModelProperty("包装方式")
    private String packageSpec;

    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("其它类型1")
    private String otherType1;

    @ApiModelProperty("其它类型2")
    private String otherType2;

    @ApiModelProperty("财务总账类别 JDE总账级")
    private String finGlType;

    @ApiModelProperty("供应商回扣类型")
    private String rebateType;

    @ApiModelProperty("计划类型")
    private String planType;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位")
    private String weightUom;

    @ApiModelProperty("采购单位")
    private String purcUom;

    @ApiModelProperty("图号")
    private String drawNo;
}
