package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 工厂分页查询参数
 *
 * @author chaofeng.xia
 * @date 2024/6/6 11:31
 */
@Data
@ApiModel("工厂分页查询参数")
public class OrgOuFactoryRpcDtoParam extends AbstractCustomFieldQueryParam implements Serializable {

    private static final long serialVersionUID = 1501028963198260158L;

    @ApiModelProperty(value = "公司id集合")
    private List<Long> ouIds;

    @ApiModelProperty(value = "公司编码集合")
    private List<String> ouCodes;

    /**
     * 工厂编码
     */
    @ApiModelProperty(value = "工厂编码")
    private List<Long> factoryIds;

    /**
     * 工厂编码
     */
    @ApiModelProperty(value = "工厂编码")
    private List<String> factoryCodes;

    /**
     * 工厂编码/名称
     */
    @ApiModelProperty(value = "工厂编码/名称")
    private String factoryCodeName;

    /**
     * 是否质检 为空查询全部
     */
    @ApiModelProperty(value = "是否质检 0：否 1：是")
    private Boolean qualityFlag;

    /**
     * 是否系统内置 为空查询全部
     */
    @ApiModelProperty(value = "是否系统内置 0：否 1：是")
    private Boolean sysFlag;

    /**
     * 是否启用 为空查询全部
     */
    @ApiModelProperty(value = "是否启用 0：禁用 1：启用")
    private Boolean enable;
}
