package com.tianlala.system.api.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.dto.store.QueryOrgStoreRepDTO;
import com.tianlala.system.api.dto.store.QueryOrgStoreReqDTO;
import com.tianlala.system.api.dto.store.StoreLatestDTO;
import com.tianlala.system.api.dto.store.SyncStoreDataReqDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

public interface TllStoreApi {

    /**
     * 同步门店数据
     * @param reqDTO
     * @return
     */
    ApiResult<Void> syncTllStore(@RequestBody SyncStoreDataReqDTO reqDTO);

    /**
     * 查询最新的门店列表
     */
    ApiResult<List<StoreLatestDTO>> selectStoreListLatest();

    /**
     * 组织门店列表查询
     * @param reqDTO
     * @return
     */
    ApiResult<PagingVO<QueryOrgStoreRepDTO>> querOrgStorePage(@RequestBody QueryOrgStoreReqDTO reqDTO);
}
