package com.tianlala.system.api.dto.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "甜啦啦app版本控制表")
public class AppVersionControlDTO implements Serializable {

    @ApiModelProperty(value = "应用编码")
    private String appCode;
    
    @ApiModelProperty(value = "版本号")
    private String version;
    
    @ApiModelProperty(value = "版本描述")
    private String description;
    
    @ApiModelProperty(value = "下载链接")
    private String androidUrl;
    
    @ApiModelProperty(value = "是否是静默更新 0：不静默更新 1：静默更新")
    private Integer silent;
    
    @ApiModelProperty(value = "是否是强制更新 0：不强制更新 1：强制更新")
    private Integer isForce;
    
    @ApiModelProperty(value = "非wifi是否提示 0：不提示 1：提示")
    private Integer netCheck;
    
    @ApiModelProperty(value = "更新内容")
    private String note;
    
    @ApiModelProperty(value = "最新时间")
    private Date releaseDate;

}