package com.tianlala.system.api.dto.employee.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "查询下属员工 res")
@Data
public class SelectSubordinateUserResDTO implements Serializable {

    /**
     * 员工id
     */
    @ApiModelProperty(value = "员工id")
    private Long id;

    /**
     * 员工编码
     */
    @ApiModelProperty(value = "员工编码")
    private String code;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    private Long userId;

    /**
     * 登录号
     */
    @ApiModelProperty(value = "登录号")
    private String userName;

    /**
     * 企业微信id
     */
    @ApiModelProperty(value = "企业微信id")
    private String wxUserIdSource;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String gender;

    /**
     * 性别名称
     */
    @ApiModelProperty(value = "性别名称")
    private String genderName;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型")
    private String type;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型")
    private String typeName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务")
    private String duty;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职")
    private Boolean served;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private List<String> orgNames;

    /**
     * 领导员工id
     */
    @ApiModelProperty(value = "领导员工id")
    private Long leaderEmployeeId;

    /**
     * 下属用户集合
     */
    @ApiModelProperty(value = "下属用户集合")
    private List<SelectSubordinateUserResDTO> subordinateUsers;

}