package com.tianlala.system.api.dto.jpa.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "岗位 res")
public class SysPositionResDTO implements Serializable {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 岗位编码
     */
    @ApiModelProperty(value = "岗位编码")
    private String positionCode;

    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    private String positionName;

    /**
     * 岗位描述
     */
    @ApiModelProperty(value = "岗位描述")
    private String positionDescription;

    /**
     * 组织列表
     */
    @ApiModelProperty(value = "组织列表")
    private List<OrgResDTO> orgList;

    /**
     * 角色列表
     */
    @ApiModelProperty(value = "角色列表")
    private List<RoleResDTO> roleList;

    @Data
    @ApiModel(value = "组织 res")
    public static class OrgResDTO implements Serializable {

        /**
         * 组织id
         */
        @ApiModelProperty(value = "组织id")
        private Long orgId;

        /**
         * 组织编码
         */
        @ApiModelProperty(value = "组织编码")
        private String orgCode;

        /**
         * 组织名称
         */
        @ApiModelProperty(value = "组织名称")
        private String orgName;

    }

    @Data
    @ApiModel(value = "角色 res")
    public static class RoleResDTO implements Serializable {

        /**
         * 角色id
         */
        @ApiModelProperty(value = "角色id")
        private Long roleId;

        /**
         * 角色编码
         */
        @ApiModelProperty(value = "角色编码")
        private String roleCode;

        /**
         * 角色名称
         */
        @ApiModelProperty(value = "角色名称")
        private String roleName;

    }

}