package com.tianlala.system.api.dto.store;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("甜啦啦门店")
@Data
public class SyncStoreDataReqDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店名")
    private String storeName;

    @ApiModelProperty(value = "门店地址")
    private String storeAddr;

    @ApiModelProperty("运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "省编码")
    private String provinceCode;

    @ApiModelProperty(value = "市编码")
    private String cityCode;

    @ApiModelProperty(value = "区编码")
    private String districtCode;

    @ApiModelProperty(value = "招商经理用户OAID")
    private String registrantOaMemberid;

    @ApiModelProperty(value = "省经理OAID")
    private String provincialManagerOaMemberid;

    @ApiModelProperty(value = "区域经理用户OAID")
    private String regionalManagerOaMemberid;

    @ApiModelProperty(value = "督导用户OAID")
    private String areaManagerOaMemberid;

    @ApiModelProperty(value = "报货负责人用户OAID")
    private String merchandiserOaMemberid;

    @ApiModelProperty(value = "美团负责人用户OAID")
    private String meituanManagerOaMemberid;

    @ApiModelProperty(value = "饿了么负责人用户OAID")
    private String elemeManagerOaMemberid;

    @ApiModelProperty(value = "门店类型:1.直营店2.加盟店")
    private Integer storeType;

}
