package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.TodoApi;
import com.tianlala.system.api.dto.todo.OperationReqDTO;
import com.tianlala.system.api.dto.todo.OperationResDTO;
import com.tianlala.system.api.dto.todo.SelectTodoTaskReqDTO;
import com.tianlala.system.api.dto.todo.TodoTaskReqDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + TodoProvider.PATH)
public interface TodoProvider extends TodoApi {

    String PATH = "/tll/todo";

    @ApiOperation(value = "新增待办")
    @PostMapping(value = "insertTodoTask")
    ApiResult<List<OperationResDTO>> insertTodoTask(@Validated @RequestBody List<TodoTaskReqDTO> req);

    @ApiOperation(value = "已读")
    @PostMapping(value = "read")
    ApiResult<OperationResDTO> read(@RequestBody OperationReqDTO req);

    @ApiOperation(value = "取消")
    @PostMapping(value = "cancel")
    ApiResult<OperationResDTO> cancel(@RequestBody OperationReqDTO req);

    @ApiOperation(value = "完成")
    @PostMapping(value = "complete")
    ApiResult<OperationResDTO> complete(@RequestBody OperationReqDTO req);

    @ApiOperation(value = "查询待办")
    @PostMapping(value = "selectTodoTask")
    ApiResult<PagingVO<TodoTaskReqDTO>> selectTodoTask(@RequestBody SelectTodoTaskReqDTO req);
}
