package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonEmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.UserApi;
import com.tianlala.system.api.dto.jpa.req.EmployeePageReqDTO;
import com.tianlala.system.api.dto.jpa.req.SelectUserAndStoreReqDTO;
import com.tianlala.system.api.dto.jpa.req.SysPositionOrgReqDTO;
import com.tianlala.system.api.dto.jpa.req.SysPositionReqDTO;
import com.tianlala.system.api.dto.jpa.res.*;
import com.tianlala.system.api.dto.store.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + UserProvider.PATH)
public interface UserProvider extends UserApi {

    String PATH = "/tll/user";

    /**
     * 根据两个员工id，判断 是否同为一个部门（一级部门）
     *
     * @param reqDTO
     * @return
     */
    @ApiOperation(value = "根据两个员工id，判断 是否同为一个部门（一级部门）")
    @PostMapping({"/diffUserPrimaryOrg"})
    @Override
    ApiResult<Boolean> diffUserPrimaryOrg(@RequestBody DiffUserPrimaryOrgReqDTO reqDTO);

    /**
     * 根据区域经理集合、向上级别，对应的直属领导
     *
     * @param reqDTO
     * @return
     */
    @ApiOperation(value = "根据区域经理集合、向上级别，对应的直属领导")
    @PostMapping({"/drillUpUserLead"})
    @Override
    ApiResult<List<DrillUpUserLeadRepDTO>> drillUpUserLead(@RequestBody DrillUpUserLeadReqDTO reqDTO);

    /**
     * 分页查询员工
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "员工管理分页查询")
    @PostMapping(value = "/queryByPage")
    @Override
    ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(@RequestBody EmployeePageQueryDTO queryVO);

    /**
     * 分页查询员工信息
     *
     * @param queryVO 查询参数
     * @return 查询结果
     */
    @ApiOperation(value = "分页查询员工信息")
    @PostMapping(value = "/pageQuery")
    @Override
    ApiResult<PagingVO<EmployeePagedRespVO>> pageQuery(@RequestBody CommonEmployeePageQueryVO queryVO);

    /**
     * userid获取员工信息
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    @ApiOperation(value = "userid获取员工信息")
    @PostMapping({"/queryByUserId"})
    @Override
    ApiResult<List<SysEmployeeDetailDTO>> queryByUserId(@RequestBody QueryEmployeeListReqDTO queryVO);

    /**
     * userid获取员工扩展信息
     * @param queryVO 查询参数
     * @return 分页数据
     */
    @PostMapping({"/queryByUserIdExtend"})
    ApiResult<List<SysEmployeeExtendDTO>> queryByUserIdExtend(@RequestBody QueryEmployeeListReqDTO queryVO);

    /**
     * 通过用户OA 查询中台 用户ID
     * @return
     */
    @ApiOperation(value = "通过用户OA 查询中台 用户ID")
    @GetMapping({"/queryUserIdByOaId/{oaId}"})
    @Override
    ApiResult<String> queryUserIdByOaId(@PathVariable(value = "oaId") String oaId);

    /**
     * 通过中台id，查询oa用户id
     * @param linkId 中台id
     */
    @ApiOperation(value = "通过中台id，查询oa用户id")
    @GetMapping(value = "/queryOaUserIdByLinkId")
    ApiResult<String> queryOaUserIdByLinkId(@RequestParam(value = "linkId") String linkId);

    /**
     * 查询员工和门店员工
     * @param req 入参
     */
    @ApiOperation(value = "查询员工和门店员工")
    @GetMapping(value = "/selectUserAndStore")
    ApiResult<PagingVO<SelectUserAndStoreResDTO>> selectUserAndStore(@RequestBody SelectUserAndStoreReqDTO req);

    /**
     * 查询中台id
     * @param phone 手机号
     */
    @ApiOperation(value = "甜掌柜通过手机号，查询中台id")
    @GetMapping(value = "/queryLinkIdByPhone")
    ApiResult<QueryLinkIdByPhoneRepDTO> queryLinkIdByPhone(@RequestParam(value = "phone") String phone);

    /**
     * 通过中台id，查询甜掌柜用户id
     * @param linkId 中台id
     */
    @ApiOperation(value = "通过中台id，查询甜掌柜用户id")
    @GetMapping(value = "/queryStoreUserIdByLinkId")
    ApiResult<QueryStoreUserIdByLinkIdRepDTO> queryStoreUserIdByLinkId(@RequestParam(value = "linkId") String linkId);

    /**
     * 通过中台id，获取token
     * @param userId 中台id
     */
    @ApiOperation(value = "通过中台id，获取token")
    @GetMapping(value = "/queryTokenByUserId")
    ApiResult<String> queryTokenByUserId(@RequestParam(value = "userId") String userId);

    /**
     * userID返回用戶一级部门
     * @return
     */
    @ApiOperation(value = "userID返回用戶一级部门")
    @GetMapping({"/queryUserPrimaryOrg/{userId}"})
    @Override
    ApiResult<String> queryUserPrimaryOrg(@PathVariable(value = "userId") Long userId);

    /**
     * 员工ID 返回所在组织
     * @return
     */
    @ApiOperation(value = "员工ID 返回所在组织")
    @PostMapping({"/getEmployeeOrgs"})
    @Override
    ApiResult<List<GetEmployeeOrgsRepDTO>> getEmployeeOrgs(@RequestBody GetEmployeeOrgsReqDTO reqDTO);

    /**
     * 分页查询员工信息
     *
     * @param queryVO 查询参数
     * @return 员工列表
     */
    @PostMapping({"/employeePage"})
    ApiResult<PagingVO<EmployeePagedRespVO>> employeePage(@RequestBody EmployeePageQueryVO queryVO);

    /**
     * 分页查询员工
     * @param req 入参
     */
    @PostMapping({"/extra/employeePage"})
    ApiResult<PagingVO<EmployeePageResDTO>> extraEmployeePage(@RequestBody EmployeePageReqDTO req);

    /**
     * 岗位查询
     *
     * @param req 入参
     */
    @PostMapping("/extra/getAllPositions")
    ApiResult<PagingVO<SysPositionResDTO>> getAllPositions(@RequestBody SysPositionReqDTO req);

    /**
     * 根据岗位，查询一级部门
     * @param req 入参
     */
    @PostMapping("/extra/selectPositionOrg")
    ApiResult<PagingVO<SysPositionOrgResDTO>> selectPositionOrg(@RequestBody SysPositionOrgReqDTO req);

    /**
     * 根据岗位id 查询
     */
    @PostMapping("/extra/selectPositionIds")
    ApiResult<List<SelectPositionResDTO>> getAllPositions(@RequestBody List<Long> positionIds);

    /**
     * 通过姓名，查询员工
     * @param reqDTO
     * @return
     */
    @PostMapping("/queryEmployeeByName")
    ApiResult<List<EmployeePageRespDTO>> queryEmployeeByName(@RequestBody QueryEmployeeByNameReqDTO reqDTO);

    /**
     * 通过部门编号，名称，搜索员工列表
     * @param reqDTO
     * @return
     */
    @PostMapping("/queryEmployeeListByOrg")
    ApiResult<List<QueryEmployeeListByOrgRepDTO>> queryEmployeeListByOrg(@RequestBody QueryEmployeeListByOrgReqDTO reqDTO);

    /**
     * 通过手机号，查询员工
     * @param reqDTO
     * @return
     */
    @PostMapping("/queryEmployeeByMobile")
    ApiResult<List<EmployeePageRespDTO>> queryEmployeeByMobile(@RequestBody QueryEmployeeByMobileReqDTO reqDTO);

    /**
     * 甜掌柜，查询用户信息
     *
     * @param reqDTO
     * @return
     */
    @PostMapping("/queryTLLStoreUser")
    ApiResult<List<QueryTLLStoreUserRepDTO>> queryTLLStoreUser(@RequestBody QueryTLLStoreUserReqDTO reqDTO);

    /**
     * 通过甜掌柜用户ID，查询中台ID；
     * @param reqDTO
     * @return
     */
    @PostMapping("/queryTLLStoreUserById")
    ApiResult<List<QueryTLLStoreUserByIdRepDTO>> queryTLLStoreUserById(@RequestBody QueryTLLStoreUserByIdReqDTO reqDTO);

    /**
     * userid，查询所在组织信息；
     * @param reqDTO
     * @return
     */
    @PostMapping("/getDefOrgsByUserId")
    ApiResult<Map<Long, List<SysOrgBasicDTO>>> getDefOrgsByUserId(@RequestBody GetOrgsByUserIdReqDTO reqDTO);
}
