package com.tianlala.system.api.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonEmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.tianlala.system.api.dto.jpa.req.EmployeePageReqDTO;
import com.tianlala.system.api.dto.jpa.req.SelectUserAndStoreReqDTO;
import com.tianlala.system.api.dto.jpa.req.SysPositionOrgReqDTO;
import com.tianlala.system.api.dto.jpa.req.SysPositionReqDTO;
import com.tianlala.system.api.dto.jpa.res.*;
import com.tianlala.system.api.dto.store.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

public interface UserApi {
    /**
     * 根据两个员工id，判断 是否同为一个部门（一级部门）
     *
     * @param reqDTO
     * @return
     */
    ApiResult<Boolean> diffUserPrimaryOrg(DiffUserPrimaryOrgReqDTO reqDTO);

    /**
     * 根据区域经理集合、向上级别，对应的直属领导
     *
     * @param reqDTO
     * @return
     */
    ApiResult<List<DrillUpUserLeadRepDTO>> drillUpUserLead(DrillUpUserLeadReqDTO reqDTO);

    /**
     * 分页查询员工
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(EmployeePageQueryDTO queryVO);

    /**
     * 分页查询员工信息
     *
     * @param queryVO 查询参数
     * @return 查询结果
     */
    ApiResult<PagingVO<EmployeePagedRespVO>> pageQuery(CommonEmployeePageQueryVO queryVO);

    /**
     * userid获取员工信息
     *
     * @param queryVO 查询参数
     * @return 分页数据
     */
    ApiResult<List<SysEmployeeDetailDTO>> queryByUserId(QueryEmployeeListReqDTO queryVO);

    /**
     * userid获取员工扩展信息
     * @param queryVO 查询参数
     * @return 分页数据
     */
    ApiResult<List<SysEmployeeExtendDTO>> queryByUserIdExtend(@RequestBody QueryEmployeeListReqDTO queryVO);

    /**
     * 通过用户OA 查询中台 用户ID
     *
     * @return
     */
    ApiResult<String> queryUserIdByOaId(String oaId);

    /**
     * userID返回用戶一级部门
     * @param userId
     * @return
     */
    ApiResult<String> queryUserPrimaryOrg(Long userId);

    /**
     * 查询员工和门店员工
     * @param req 入参
     */
    ApiResult<PagingVO<SelectUserAndStoreResDTO>> selectUserAndStore(SelectUserAndStoreReqDTO req);

    /**
     * 员工ID 返回所在组织
     * @return
     */
    ApiResult<List<GetEmployeeOrgsRepDTO>> getEmployeeOrgs(GetEmployeeOrgsReqDTO reqDTO);

    /**
     * 分页查询员工信息
     *
     * @param queryVO 查询参数
     * @return 员工列表
     */
    ApiResult<PagingVO<EmployeePagedRespVO>> employeePage(EmployeePageQueryVO queryVO);

    /**
     * 分页查询员工
     * @param req 入参
     */
    ApiResult<PagingVO<EmployeePageResDTO>> extraEmployeePage(EmployeePageReqDTO req);

    /**
     * 岗位查询
     *
     * @param req 入参
     */
    ApiResult<PagingVO<SysPositionResDTO>> getAllPositions(SysPositionReqDTO req);

    /**
     * 根据岗位，查询一级部门
     * @param req 入参
     */
    ApiResult<PagingVO<SysPositionOrgResDTO>> selectPositionOrg(SysPositionOrgReqDTO req);

    /**
     * 根据岗位id 查询
     */
    ApiResult<List<SelectPositionResDTO>> getAllPositions(List<Long> positionIds);

    /**
     * 通过姓名，查询员工
     * @param reqDTO
     * @return
     */
    ApiResult<List<EmployeePageRespDTO>> queryEmployeeByName(QueryEmployeeByNameReqDTO reqDTO);
}
