package com.tianlala.system.api.dto.jpa.req;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "员工分页 req")
public class EmployeePageReqDTO extends AbstractCustomFieldQueryParam {
    private static final long serialVersionUID = -761229337290141030L;

    /**
     * 组织id[直属]
     */
    @ApiModelProperty(value = "组织id[直属]", position = 1)
    private Long orgId;

    /**
     * 组织ids[直属]
     */
    @ApiModelProperty(value = "组织ids[直属]")
    private List<Long> orgIds;

    /**
     * 组织ID[下属]
     */
    @ApiModelProperty(value = "组织id[下属]", position = 1)
    private Long orgIdBelong;

    /**
     * 组织ids[下属]
     */
    @ApiModelProperty(value = "组织ids[下属]")
    private List<Long> orgIdsBelong;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 3)
    private String code;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 4)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 5)
    private String fullName;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private List<String> fullNames;

    /**
     * 岗位ids
     */
    @ApiModelProperty(value = "岗位ids")
    private List<Long> dutyIds;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 6)
    private String gender;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型，[UDC]cloudt-system:employeeType", position = 6)
    private String type;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", position = 8)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;

    /**
     * 是否拥有登录账号
     */
    @ApiModelProperty(value = "是否拥有登录账号", position = 10)
    private Boolean hasAccount;

    /**
     * 是否返回员工角色
     */
    @ApiModelProperty(value = "是否返回员工角色", position = 32)
    private Boolean withRole;
}
