package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.AppVersionApi;
import com.tianlala.system.api.dto.app.AppVersionControlDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + AppVersionProvider.PATH)
public interface AppVersionProvider extends AppVersionApi {
    String PATH = "/tll/app/version";

    /**
     * 查询app版本
     * @param appCode 应用编码
     */
    @GetMapping(value = "/selectAppVersion")
    ApiResult<List<AppVersionControlDTO>> selectAppVersion(@RequestParam(value = "appCode") String appCode);

    /**
     * 查询最新app版本
     * @param appCode 应用编码
     */
    @GetMapping(value = "/selectAppVersionLatest")
    ApiResult<AppVersionControlDTO> selectAppVersionLatest(@RequestParam(value = "appCode") String appCode);

}
