package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.dto.italent.QueryItalentIdByUserIdRepDTO;
import com.tianlala.system.api.dto.italent.QueryItalentIdByUserIdReqDTO;
import com.tianlala.system.api.dto.store.QueryUserCertificateImgUrlRepDTO;
import com.tianlala.system.api.dto.store.QueryUserCertificateImgUrlReqDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ItalentProvider.PATH)
public interface ItalentProvider {
    String PATH = "/tll/italent";

    /**
     * 证照图片地址（健康证）
     *
     * @return
     */
    @PostMapping("/queryUserCertificateImgUrl")
    QueryUserCertificateImgUrlRepDTO queryUserCertificateImgUrl(@RequestBody QueryUserCertificateImgUrlReqDTO reqDTO);

    /**
     * 根据用户id查询北森用户id
     * @return
     */
    @PostMapping("/queryItalentIdByUserId")
    ApiResult<List<QueryItalentIdByUserIdRepDTO>> queryItalentIdByUserId(@RequestBody QueryItalentIdByUserIdReqDTO reqDTO);

    /**
     * 获取北森token
     * @return
     */
    @GetMapping("/getItalentToken")
    ApiResult<String> getItalentToken();
}
