package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.TllStoreApi;
import com.tianlala.system.api.dto.store.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + TllStoreProvider.PATH)
public interface TllStoreProvider extends TllStoreApi {
    String PATH = "/tll/store";

    /**
     * 同步门店数据
     * @param reqDTO
     * @return
     */
    @PostMapping("/syncTllStore")
    ApiResult<Void> syncTllStore(@RequestBody SyncStoreDataReqDTO reqDTO);

    /**
     * 查询最新的门店列表
     */
    @PostMapping("/selectStoreLatest")
    ApiResult<List<StoreLatestDTO>> selectStoreListLatest();

    /**
     * 组织门店列表查询
     * @param reqDTO
     * @return
     */
    @PostMapping("/querOrgStorePage")
    ApiResult<PagingVO<QueryOrgStoreRepDTO>> querOrgStorePage(@RequestBody QueryOrgStoreReqDTO reqDTO);

    /**
     * userId 查询门店编码
     * @return
     */
    @GetMapping({"/queryStoreByUserId/{userId}"})
    ApiResult<List<QueryStoreByUserReqDTO>> queryStoreByUserId(@PathVariable(value = "userId") Long userId);

    /**
     * userId 查询门店编码
     * @return
     */
    @GetMapping({"/queryStoreCodeByUserId/{userId}"})
    ApiResult<Set<String>> queryStoreCodeByUserId(@PathVariable(value = "userId") Long userId);

    /**
     * userId 查询门店编码（批量）
     * @return
     */
    @PostMapping({"/queryStoreCodeByUserIds"})
    ApiResult<List<QueryStoreCodeByUserIdsRepDTO>> queryStoreCodeByUserIds(@RequestBody QueryStoreCodeByUserIdsReqDTO reqDTO);

    /**
     * orgId 查询门店编码
     * @param orgId
     * @return
     */
    @GetMapping({"/queryStoreByOrgId/{orgId}"})
    ApiResult<List<String>> queryStoreByOrgId(@PathVariable(value = "orgId") Long orgId);

    /**
     * orgId 查询门店编码（批量）
     * @param reqDTO
     * @return
     */
    @PostMapping({"/queryStoreByOrgIds"})
    ApiResult<List<QueryStoreByOrgIdsRepDTO>> queryStoreByOrgIds(@RequestBody QueryStoreByOrgIdsReqDTO reqDTO);
}
