package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.dto.store.DepartmentLeadRepDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + WorkFlowProvider.PATH)
public interface WorkFlowProvider {
    String PATH = "/tll/workFlow";


    /**
     * 当前人，部门主管
     * @return 部门主管信息
     */
    @GetMapping({"/queryDepartmentLead/{userId}"})
    ApiResult<DepartmentLeadRepDTO> queryDepartmentLead(@PathVariable Long userId);

    /**
     * 一级部门主管信息
     * @param userId 用户ID
     * @return DepartmentLeadRepDTO
     */
    @GetMapping({"/queryPrimaryDepartmentLead/{userId}"})
    ApiResult<DepartmentLeadRepDTO> queryPrimaryDepartmentLead(@PathVariable Long userId);
}
