package com.tianlala.system.api.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tianlala.system.api.dto.employee.req.EmployeeReqDTO;
import com.tianlala.system.api.dto.employee.req.PageInfoReqDTO;
import com.tianlala.system.api.dto.employee.req.SelectSubordinateUserNameReqDTO;
import com.tianlala.system.api.dto.employee.req.SelectSubordinateUserReqDTO;
import com.tianlala.system.api.dto.employee.res.EmployeeResDTO;
import com.tianlala.system.api.dto.employee.res.PageInfoResDTO;
import com.tianlala.system.api.dto.employee.res.SelectEmployeeExcludeStoreUserResDTO;
import com.tianlala.system.api.dto.employee.res.SelectSubordinateUserResDTO;

import java.util.List;

public interface EmployeeApi {

    /**
     * 查询下属员工
     * @param req 入参
     */
    ApiResult<List<SelectSubordinateUserResDTO>> selectSubordinateUserIdByUserId(SelectSubordinateUserReqDTO req);

    /**
     * 查询下属员工，用户名称模糊查询
     * @param req 入参
     */
    ApiResult<PageInfoResDTO<SelectSubordinateUserResDTO>> selectSubordinateUserIdByUserName(PageInfoReqDTO<SelectSubordinateUserNameReqDTO> req);

    /**
     * 根据分页条件，查询所有员工
     * @param req 入参
     */
    ApiResult<PageInfoResDTO<EmployeeResDTO>> selectEmployee(PageInfoReqDTO<EmployeeReqDTO> req);

    /**
     * 根据分页条件，查询所有员工
     * @param req 入参
     */
    PageInfoResDTO<EmployeeResDTO> selectEmployeePage(PageInfoReqDTO<EmployeeReqDTO> req);

    /**
     * 查询员工信息，不包含门店加盟商
     * @param userName 用户名称
     */
    ApiResult<List<SelectEmployeeExcludeStoreUserResDTO>> selectEmployeeExcludeStoreUser(String userName);

}
