package com.tianlala.system.api.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tianlala.system.api.dto.todo.OperationReqDTO;
import com.tianlala.system.api.dto.todo.OperationResDTO;
import com.tianlala.system.api.dto.todo.SelectTodoTaskReqDTO;
import com.tianlala.system.api.dto.todo.TodoTaskReqDTO;

import java.util.List;

public interface TodoApi {

    /**
     * 新增待办
     * @param req 入参
     */
    ApiResult<List<OperationResDTO>> insertTodoTask(List<TodoTaskReqDTO> req);

    /**
     * 已读
     * @param req 入参
     */
    ApiResult<OperationResDTO> read(OperationReqDTO req);

    /**
     * 取消
     * @param req 入参
     */
    ApiResult<OperationResDTO> cancel(OperationReqDTO req);

    /**
     * 完成
     * @param req 入参
     */
    ApiResult<OperationResDTO> complete(OperationReqDTO req);

    /**
     * 查询待办
     * @param req 入参
     */
    ApiResult<PagingVO<TodoTaskReqDTO>> selectTodoTask(SelectTodoTaskReqDTO req);

}
