package com.tianlala.system.api.dto.employee.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel(value = "分页对象 res")
public class PageInfoResDTO<T> implements Serializable {

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码")
    private Long page = 1L;

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码")
    private Long current = 1L;

    /**
     * 条数
     */
    @ApiModelProperty(value = "条数")
    private Long size = 10L;

    /**
     * 总数
     */
    @ApiModelProperty(value = "总数")
    private Long total;

    @ApiModelProperty(value = "数据")
    private List<T> list;

}