package com.tianlala.system.api.dto.store;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
@ApiModel(value="最新的门店")
public class StoreLatestDTO implements Serializable {

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店名")
    private String storeName;

    @ApiModelProperty(value = "门店地址")
    private String storeAddr;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "区域经理")
    private String areaManager;

    @ApiModelProperty(value = "区域经理用户企微ID")
    private String areaManagerUserid;

    @ApiModelProperty(value = "区域经理用户OAID")
    private String areaManagerOaMemberid;

    @ApiModelProperty(value = "报货负责人")
    private String merchandiser;

    @ApiModelProperty(value = "报货负责人用户企微ID")
    private String merchandiserUserid;

    @ApiModelProperty(value = "报货负责人用户OAID")
    private String merchandiserOaMemberid;

    @ApiModelProperty(value = "美团负责人")
    private String meituanManager;

    @ApiModelProperty(value = "美团负责人用户企微ID")
    private String meituanManagerUserid;

    @ApiModelProperty(value = "美团负责人用户OAID")
    private String meituanManagerOaMemberid;

    @ApiModelProperty(value = "饿了么负责人")
    private String elemeManager;

    @ApiModelProperty(value = "饿了么负责人用户企微ID")
    private String elemeManagerUserid;

    @ApiModelProperty(value = "饿了么负责人用户OAID")
    private String elemeManagerOaMemberid;

}
