package com.tianlala.system.api.dto.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class TllStoreWorkFlowRepDTO {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "门店地址")
    private String storeAddr;

    @ApiModelProperty(value = "门店ID")
    private Integer storeId;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "表单类型：0：草稿；1：正式")
    private Integer docStatus;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "原因")
    private String reason;

    @ApiModelProperty(value = "流程ID")
    private String procInstId;

    @ApiModelProperty(value = "流程状态")
    private String procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "流程评论")
    private String comment;

    @ApiModelProperty(value = "是否可编辑")
    private Boolean canEdit;
}
