package com.tianlala.system.api.dto.todo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tianlala.system.api.dto.employee.res.PageInfoResDTO;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class SelectTodoTaskReqDTO extends PageInfoResDTO<SelectTodoTaskReqDTO> implements Serializable {

    /**
     * 待办任务id 格式为TAS+YYYYMMDD+1
     */
    private String taskId;

    /**
     * 待办类型
     */
    private String taskType;

    /**
     * 待办任务id 格式为TAS+YYYYMMDD+1
     */
    private List<String> taskIdList;

    /**
     * 展示位置 0：PC端 1：APP端 2：app甜掌柜 3：甜管家
     */
    private Integer displayPosition;

    /**
     * 业务类型编码
     */
    private String businessTypeCode;

    /**
     * 业务编码
     */
    private String businessCode;

    /**
     * 业务编码
     */
    private List<String> businessCodeList;

    /**
     * 授权状态 0：全部 1：当前用户
     */
    private Integer authStatus;

    /**
     * 状态 0：待处理 1：已取消 2：已处理 3：已过期
     */
    private Integer status;

    /**
     * 状态 0：待处理 1：已取消 2：已处理 3：已过期
     */
    private List<Integer> statusList;

    /**
     * 待办标题
     */
    private String title;

    /**
     * 0：已读 1：未读
     */
    private Integer read;

    /**
     * 关联业务单号
     */
    private String relatedBusinessNo;

    /**
     * 关联业务单号
     */
    private List<String> relatedBusinessNoList;

    /**
     * 接收人类型 0：员工 1：门店 2：供应商
     */
    private Integer recipientType;

    /**
     * 接收人类型为 0：用户中台id 1:门店编码 2：供应商编码 接受人类型编码 多个以,拼接
     */
    private String recipientCode;

    /**
     * 接收人中台id
     */
    private String recipient;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String createdTime;

    /**
     * 处理时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String handledTime;

    /**
     * 创建开始时间（发起开始时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String createdStartTime;

    /**
     * 创建结束时间（发起结束时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String createdEndTime;

    /**
     * 处理开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String handledStartTime;


    /**
     * 处理结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String handledEndTime;

}