package com.tianlala.system.api.dto.todo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class TodoTaskReqDTO implements Serializable {

    /**
    * 待办任务id 格式为TAS+YYYYMMDD+1
    */
    private String taskId;

    /**
    * 待办类型
    */
    private String taskType;

    /**
     * 创建类型 0：系统配置 1：外部给值
     */
    @NotNull(message = "创建类型必填")
    private Integer createType;

    /**
    * 状态 0：待处理 1：已取消 2：已处理 3：已过期
    */
    private Integer status;

    /**
     * 状态 0：待处理 1：已取消 2：已处理 3：已过期
     */
    private String statusName;

    /**
    * 待办标题
    */
    @NotEmpty(message = "待办标题必填")
    private String title;

    /**
    * 0：已读 1：未读
    */
    private Integer read;

    /**
    * 截止时间
    */
    private Date dueDate;

    /**
    * 优先级
    */
    private String priority;

    /**
     * 来源 1:门店盘点
     */
    private Integer source;

    /**
    * 业务类型编码
    */
    private String businessTypeCode;

    /**
    * 关联业务单号
    */
    @NotEmpty(message = "关联业务单号必填")
    private String relatedBusinessNo;

    /**
    * 接收人类型 0：员工 1：门店 2：供应商
    */
    @NotNull(message = "接收人类型必填")
    private Integer recipientType;

    /**
     * 接受人 接收人类型为 0：用户中台id 1:门店编码 2：供应商编码
     */
    @NotEmpty(message = "接收人必填")
    private String recipient;

    /**
     * 接受人类型编码，多个以,拼接，接收人类型为 0：用户中台id 1:门店编码 2：供应商编码
     */
    private String recipientCode;

    /**
    * 展示位置 0：PC端 1：APP端 2：app甜掌柜 3：甜管家
    */
    @NotNull(message = "展示位置必填")
    private Integer displayPosition;

    /**
    * PC端跳转链接
    */
    private String pcRedirectUrl;

    /**
    * APP跳转链接
    */
    private String appRedirectUrl;

    /**
     * 甜管家跳转链接
     */
    private String appHouseKeepRedirectUrl;

    /**
     * 甜掌柜跳转链接
     */
    private String appShopKeeperUrl;

    /**
    * 业务编码
    */
    private String businessCode;

    /**
    * 处理人
    */
    private String handler;

    /**
     * 处理人
     */
    private String handlerName;

    /**
     * 处理人id
     */
    private String handlerId;

    /**
    * 处理时间
    */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date handledTime;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdTime;

}