package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.EmployeeApi;
import com.tianlala.system.api.dto.employee.req.EmployeeReqDTO;
import com.tianlala.system.api.dto.employee.req.PageInfoReqDTO;
import com.tianlala.system.api.dto.employee.req.SelectSubordinateUserNameReqDTO;
import com.tianlala.system.api.dto.employee.req.SelectSubordinateUserReqDTO;
import com.tianlala.system.api.dto.employee.res.EmployeeResDTO;
import com.tianlala.system.api.dto.employee.res.PageInfoResDTO;
import com.tianlala.system.api.dto.employee.res.SelectEmployeeExcludeStoreUserResDTO;
import com.tianlala.system.api.dto.employee.res.SelectSubordinateUserResDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + EmployeeProvider.PATH)
public interface EmployeeProvider extends EmployeeApi {

    String PATH = "/tll/employee";

    @ApiOperation(value = "查询下属员工")
    @PostMapping(value = "/selectSubordinateUserIdByUserId")
    ApiResult<List<SelectSubordinateUserResDTO>> selectSubordinateUserIdByUserId(@RequestBody SelectSubordinateUserReqDTO req);

    @ApiOperation(value = "查询下属员工，用户名称模糊查询")
    @PostMapping(value = "/selectSubordinateUserIdByUserName")
    ApiResult<PageInfoResDTO<SelectSubordinateUserResDTO>> selectSubordinateUserIdByUserName(@RequestBody PageInfoReqDTO<SelectSubordinateUserNameReqDTO> req);

    @ApiOperation(value = "查询下属员工(返回userID，无基础信息)")
    @PostMapping(value = "/selectSubordinateUserIdByUserIdV2")
    ApiResult<Set<Long>> selectSubordinateUserIdByUserIdV2(@RequestBody SelectSubordinateUserReqDTO req);

    @ApiOperation(value = "根据分页条件，查询所有员工")
    @PostMapping(value = "/selectEmployee")
    ApiResult<PageInfoResDTO<EmployeeResDTO>> selectEmployee(@RequestBody PageInfoReqDTO<EmployeeReqDTO> req);


    @ApiOperation(value = "根据分页条件，查询所有员工")
    @PostMapping(value = "/selectEmployeePage")
    PageInfoResDTO<EmployeeResDTO> selectEmployeePage(@RequestBody PageInfoReqDTO<EmployeeReqDTO> req);

    @ApiOperation(value = "查询员工信息，不包含门店加盟商")
    @GetMapping(value = "/selectEmployeeExcludeStoreUser")
    ApiResult<List<SelectEmployeeExcludeStoreUserResDTO>> selectEmployeeExcludeStoreUser(@RequestParam(value = "userName") String userName);

}
