package com.tianlala.system.api.provier;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.tianlala.system.api.Application;
import com.tianlala.system.api.api.OrgApi;
import com.tianlala.system.api.dto.store.GetPrimaryOrgRepDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + OrgProvider.PATH)
public interface OrgProvider extends OrgApi {
    String PATH = "/tll/org";

    /**
     * 获取行政组织树-树形结构
     *
     * @param reqDTO
     * @return
     */
    @PostMapping({"/getTree"})
    ApiResult<List<OrgTreeNodeRespVO>> getTree();

    /**
     * 一级部门
     *
     * @return
     */
    @PostMapping({"/getPrimaryDept"})
    ApiResult<List<GetPrimaryOrgRepDTO>> getPrimaryOrg();

    /**
     * 查询组织列表
     *
     * @param queryDTO 查询参数
     * @return 组织列表
     */
    @PostMapping("queryList")
    ApiResult<List<SysOrgBasicDTO>> queryList(@RequestBody SysOrgQueryDTO queryDTO);
}
