/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.interfaces.dto;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpMethod;

public class SyncResult
implements Serializable {
    private String thirdApp;
    private Boolean success;
    private String resp;
    private String bussinessKey;
    private String request;
    private Boolean reqSuccess;
    private String reqFailMsg;
    private LocalDateTime reqTime;
    private Map<String, String[]> reqHeaders;
    private HttpMethod reqMethod;
    private Map<String, String[]> reqQueryParams;
    @NotBlank(message="\u8bf7\u6c42\u7684\u63a5\u53e3\u4e3a\u7a7a")
    private @NotBlank(message="\u8bf7\u6c42\u7684\u63a5\u53e3\u4e3a\u7a7a") String uri;
    @NotNull(message="Restful\u6807\u8bc6\u4e3a\u7a7a")
    private @NotNull(message="Restful\u6807\u8bc6\u4e3a\u7a7a") Boolean restful;
    private String serverAddr;
    private ThirdApiRetryParamDTO retryParamDTO;

    public static SyncResult success(String req, String resp, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp, Map<String, String[]> reqHeaders) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(true);
        result.setReqSuccess(true);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqHeaders(reqHeaders);
        return result;
    }

    public static SyncResult success(String req, String resp, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp, Map<String, String[]> reqHeaders, String bussinessKey) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(true);
        result.setReqSuccess(true);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqHeaders(reqHeaders);
        result.setBussinessKey(bussinessKey);
        return result;
    }

    public static SyncResult fail(String req, String resp, Boolean reqSuccess, String reqFailMsg, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp, Map<String, String[]> reqHeaders) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(false);
        result.setReqSuccess(reqSuccess);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqFailMsg(reqFailMsg);
        result.setReqHeaders(reqHeaders);
        return result;
    }

    public static SyncResult fail(String req, String resp, Boolean reqSuccess, String reqFailMsg, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp, Map<String, String[]> reqHeaders, String bussinessKey) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(false);
        result.setReqSuccess(reqSuccess);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqFailMsg(reqFailMsg);
        result.setReqHeaders(reqHeaders);
        result.setBussinessKey(bussinessKey);
        return result;
    }

    public String getData() {
        if (this.success == null || !this.success.booleanValue()) {
            throw new BusinessException("\u5931\u8d25\uff1a" + this.resp);
        }
        return this.resp;
    }

    public String getThirdApp() {
        return this.thirdApp;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getResp() {
        return this.resp;
    }

    public String getBussinessKey() {
        return this.bussinessKey;
    }

    public String getRequest() {
        return this.request;
    }

    public Boolean getReqSuccess() {
        return this.reqSuccess;
    }

    public String getReqFailMsg() {
        return this.reqFailMsg;
    }

    public LocalDateTime getReqTime() {
        return this.reqTime;
    }

    public Map<String, String[]> getReqHeaders() {
        return this.reqHeaders;
    }

    public HttpMethod getReqMethod() {
        return this.reqMethod;
    }

    public Map<String, String[]> getReqQueryParams() {
        return this.reqQueryParams;
    }

    public String getUri() {
        return this.uri;
    }

    public Boolean getRestful() {
        return this.restful;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public ThirdApiRetryParamDTO getRetryParamDTO() {
        return this.retryParamDTO;
    }

    public void setThirdApp(String thirdApp) {
        this.thirdApp = thirdApp;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setResp(String resp) {
        this.resp = resp;
    }

    public void setBussinessKey(String bussinessKey) {
        this.bussinessKey = bussinessKey;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setReqSuccess(Boolean reqSuccess) {
        this.reqSuccess = reqSuccess;
    }

    public void setReqFailMsg(String reqFailMsg) {
        this.reqFailMsg = reqFailMsg;
    }

    public void setReqTime(LocalDateTime reqTime) {
        this.reqTime = reqTime;
    }

    public void setReqHeaders(Map<String, String[]> reqHeaders) {
        this.reqHeaders = reqHeaders;
    }

    public void setReqMethod(HttpMethod reqMethod) {
        this.reqMethod = reqMethod;
    }

    public void setReqQueryParams(Map<String, String[]> reqQueryParams) {
        this.reqQueryParams = reqQueryParams;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setRestful(Boolean restful) {
        this.restful = restful;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public void setRetryParamDTO(ThirdApiRetryParamDTO retryParamDTO) {
        this.retryParamDTO = retryParamDTO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncResult)) {
            return false;
        }
        SyncResult other = (SyncResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Boolean this$reqSuccess = this.getReqSuccess();
        Boolean other$reqSuccess = other.getReqSuccess();
        if (this$reqSuccess == null ? other$reqSuccess != null : !((Object)this$reqSuccess).equals(other$reqSuccess)) {
            return false;
        }
        Boolean this$restful = this.getRestful();
        Boolean other$restful = other.getRestful();
        if (this$restful == null ? other$restful != null : !((Object)this$restful).equals(other$restful)) {
            return false;
        }
        String this$thirdApp = this.getThirdApp();
        String other$thirdApp = other.getThirdApp();
        if (this$thirdApp == null ? other$thirdApp != null : !this$thirdApp.equals(other$thirdApp)) {
            return false;
        }
        String this$resp = this.getResp();
        String other$resp = other.getResp();
        if (this$resp == null ? other$resp != null : !this$resp.equals(other$resp)) {
            return false;
        }
        String this$bussinessKey = this.getBussinessKey();
        String other$bussinessKey = other.getBussinessKey();
        if (this$bussinessKey == null ? other$bussinessKey != null : !this$bussinessKey.equals(other$bussinessKey)) {
            return false;
        }
        String this$request = this.getRequest();
        String other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$reqFailMsg = this.getReqFailMsg();
        String other$reqFailMsg = other.getReqFailMsg();
        if (this$reqFailMsg == null ? other$reqFailMsg != null : !this$reqFailMsg.equals(other$reqFailMsg)) {
            return false;
        }
        LocalDateTime this$reqTime = this.getReqTime();
        LocalDateTime other$reqTime = other.getReqTime();
        if (this$reqTime == null ? other$reqTime != null : !((Object)this$reqTime).equals(other$reqTime)) {
            return false;
        }
        Map<String, String[]> this$reqHeaders = this.getReqHeaders();
        Map<String, String[]> other$reqHeaders = other.getReqHeaders();
        if (this$reqHeaders == null ? other$reqHeaders != null : !((Object)this$reqHeaders).equals(other$reqHeaders)) {
            return false;
        }
        HttpMethod this$reqMethod = this.getReqMethod();
        HttpMethod other$reqMethod = other.getReqMethod();
        if (this$reqMethod == null ? other$reqMethod != null : !this$reqMethod.equals(other$reqMethod)) {
            return false;
        }
        Map<String, String[]> this$reqQueryParams = this.getReqQueryParams();
        Map<String, String[]> other$reqQueryParams = other.getReqQueryParams();
        if (this$reqQueryParams == null ? other$reqQueryParams != null : !((Object)this$reqQueryParams).equals(other$reqQueryParams)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$serverAddr = this.getServerAddr();
        String other$serverAddr = other.getServerAddr();
        if (this$serverAddr == null ? other$serverAddr != null : !this$serverAddr.equals(other$serverAddr)) {
            return false;
        }
        ThirdApiRetryParamDTO this$retryParamDTO = this.getRetryParamDTO();
        ThirdApiRetryParamDTO other$retryParamDTO = other.getRetryParamDTO();
        return !(this$retryParamDTO == null ? other$retryParamDTO != null : !this$retryParamDTO.equals(other$retryParamDTO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Boolean $reqSuccess = this.getReqSuccess();
        result = result * 59 + ($reqSuccess == null ? 43 : ((Object)$reqSuccess).hashCode());
        Boolean $restful = this.getRestful();
        result = result * 59 + ($restful == null ? 43 : ((Object)$restful).hashCode());
        String $thirdApp = this.getThirdApp();
        result = result * 59 + ($thirdApp == null ? 43 : $thirdApp.hashCode());
        String $resp = this.getResp();
        result = result * 59 + ($resp == null ? 43 : $resp.hashCode());
        String $bussinessKey = this.getBussinessKey();
        result = result * 59 + ($bussinessKey == null ? 43 : $bussinessKey.hashCode());
        String $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $reqFailMsg = this.getReqFailMsg();
        result = result * 59 + ($reqFailMsg == null ? 43 : $reqFailMsg.hashCode());
        LocalDateTime $reqTime = this.getReqTime();
        result = result * 59 + ($reqTime == null ? 43 : ((Object)$reqTime).hashCode());
        Map<String, String[]> $reqHeaders = this.getReqHeaders();
        result = result * 59 + ($reqHeaders == null ? 43 : ((Object)$reqHeaders).hashCode());
        HttpMethod $reqMethod = this.getReqMethod();
        result = result * 59 + ($reqMethod == null ? 43 : $reqMethod.hashCode());
        Map<String, String[]> $reqQueryParams = this.getReqQueryParams();
        result = result * 59 + ($reqQueryParams == null ? 43 : ((Object)$reqQueryParams).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $serverAddr = this.getServerAddr();
        result = result * 59 + ($serverAddr == null ? 43 : $serverAddr.hashCode());
        ThirdApiRetryParamDTO $retryParamDTO = this.getRetryParamDTO();
        result = result * 59 + ($retryParamDTO == null ? 43 : $retryParamDTO.hashCode());
        return result;
    }

    public String toString() {
        return "SyncResult(thirdApp=" + this.getThirdApp() + ", success=" + this.getSuccess() + ", resp=" + this.getResp() + ", bussinessKey=" + this.getBussinessKey() + ", request=" + this.getRequest() + ", reqSuccess=" + this.getReqSuccess() + ", reqFailMsg=" + this.getReqFailMsg() + ", reqTime=" + String.valueOf(this.getReqTime()) + ", reqHeaders=" + String.valueOf(this.getReqHeaders()) + ", reqMethod=" + String.valueOf(this.getReqMethod()) + ", reqQueryParams=" + String.valueOf(this.getReqQueryParams()) + ", uri=" + this.getUri() + ", restful=" + this.getRestful() + ", serverAddr=" + this.getServerAddr() + ", retryParamDTO=" + String.valueOf(this.getRetryParamDTO()) + ")";
    }
}

