package com.elitesland.sale.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.SaleItemScopeRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 通过此接口将商品销售范围同步给销售域
 *
 * @author : chb
 */
@FeignClient(name = Application.NAME, path = LmItemScopeSyncRpcService.URI)
public interface LmItemScopeSyncRpcService {

    String URI = Application.URI_PREFIX + "/itemScope";

    @PostMapping("/syncItemScope")
    ApiResult<Void> syncItemScope(@RequestBody SaleItemScopeRpcDTO dto);
}
