package com.elitesland.sale.lm.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * spu上架信息表DO
 *
 * @author : JS
 * @date : 2023-3-2
 */
@Data
@ApiModel(value = "spu上架信息表", description = "spu上架信息表")
public class ItmSpuPutawayRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 商品SPU_ID
     */
    @ApiModelProperty(name = "商品SPU_ID")
    private Long spuId;

    /**
     * 发货基地
     */
    @ApiModelProperty(name = "发货基地")
    private Long desId;

    /**
     * 上架状态UDC：已上架/已下架
     */
    @ApiModelProperty(name = "上架状态UDC：已上架/已下架")
    private String putawayStatus;

    /**
     * 商品渠道类型:UDC
     */
    @ApiModelProperty(name = "商品渠道类型:UDC")
    private String channelType;

    /**
     * sku上架信息
     */
    @ApiModelProperty(name = "sku上架信息")
    List<ItmSkuPutawayRpcDTO> skuList;

}