package com.elitesland.sale.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.ItemRpcUpdateParam;
import com.elitesland.sale.lm.rpc.param.ItmPutawayItemRpcDTO;
import com.elitesland.sale.lm.rpc.param.ItmSpuPutawayRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 商品上下架
 *
 * @author : JS
 * @date 2023/03/03 9:53
 */
@FeignClient(name = Application.NAME, path = LmItmPutawayRpcService.URI)
public interface LmItmPutawayRpcService {

    String URI = Application.URI_PREFIX + "/lm/item/putaway";

    /**
     * 发布到上下架信息
     *
     * @param params 参数
     * @return 无
     */
    @PostMapping("/publish")
    ApiResult<Object> publish(@RequestBody List<ItmSpuPutawayRpcDTO> params);

    /**
     * 通过商品id下架
     *
     * @param itemIds 商品id
     * @return 无
     */
    @PostMapping("/soldOutByItemIds")
    ApiResult<Object> soldOutByItemIds(@RequestBody List<Long> itemIds);

    @GetMapping("/findPutawayItemIds")
    ItmPutawayItemRpcDTO findPutawayItemIds();

    /**
     * 通知销售域商品更新
     * @return
     */
    @PostMapping("/notifyItemUpdate")
    ApiResult<Void> notifyItemUpdate(@RequestBody List<ItemRpcUpdateParam> params);

}
