package com.elitesland.sale.lm.rpc;

import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.ShoppingCartRpcDTO;
import com.elitesland.sale.lm.rpc.param.query.ShoppingCartQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/3/13
 */
@FeignClient(name = Application.NAME, path = LmShoppingCartRpcService.URI)
public interface LmShoppingCartRpcService {
    String URI = Application.URI_PREFIX + "/cart";

    /**
     * 汇总查看所有客户的购物车数量
     *
     * @param param
     * @return
     */
    @PostMapping("/count")
    List<ShoppingCartRpcDTO> countShoppingCart(@RequestBody List<ShoppingCartQueryDTO> param);

    /**
     * 根据参数查询购物车数量
     *
     * @param param
     * @return
     */
    @PostMapping("/query")
    List<ShoppingCartRpcDTO> queryShoppingCart(@RequestBody List<ShoppingCartQueryDTO> param);

    /**
     * 根据参数查询购物车配件整车
     *
     * @param params
     * @return
     */
    @PostMapping("/query10")
    List<ShoppingCartRpcDTO> queryShoppingCart10(@RequestBody List<ShoppingCartQueryDTO> params);

    /**
     * 根据参数查询购物车配件数量
     *
     * @param param
     * @return
     */
    @PostMapping("/query20")
    List<ShoppingCartRpcDTO> queryShoppingCart20(@RequestBody List<ShoppingCartQueryDTO> param);

}
