package com.elitesland.sale.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.StoreOrderCancelRpcDTO;
import com.elitesland.sale.lm.rpc.param.StoreOrderDoRpcDTO;
import com.elitesland.sale.lm.rpc.param.UpdateLogisticCodeDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author RYH
 * @date 2024/5/15
 */
@FeignClient(name = Application.NAME, path = StoreOrderRpcService.URI)
public interface StoreOrderRpcService {
    String URI = Application.URI_PREFIX + "/storeOrder";


    @PostMapping("/cancelStoreOrderDo")
    ApiResult cancelStoreOrderDoRpc(@RequestBody StoreOrderCancelRpcDTO storeOrderCancelRpcDTO);

    @PostMapping("/createStoreOrderDo")
    ApiResult createStoreOrderDoRpc(@RequestBody StoreOrderDoRpcDTO storeOrderDoRpcDTO);
    @PostMapping("/updateLogisticCode")
    ApiResult updateLogisticCode(@RequestBody List<UpdateLogisticCodeDTO> logisticCodeDTO);


}
