package com.elitesland.sale.lm.rpc.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description = "客户伙伴")
public class CustPartnerDTO implements Serializable {
    private static final long serialVersionUID = -7349019786775767280L;

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;
    @ApiModelProperty("客户号")
    private String custCode2;
    @ApiModelProperty("客户简称")
    private String custAbbr;

    @ApiModelProperty("伙伴的custId")
    private Long partnerCustId;
    @ApiModelProperty("伙伴的custCode")
    private String partnerCustCode;
    @ApiModelProperty("伙伴的custName")
    private String partnerCustName;
    @ApiModelProperty("伙伴的custCode2")
    private String partnerCustCode2;
    @ApiModelProperty("伙伴的custAbbr")
    private String partnerCustAbbr;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale", mod = "PARTNER_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("职能")
    @SysCode(sys = "yst-sale", mod = "PARTNER_FUNC")
    private String func;
    private String funcName;

    @ApiModelProperty("是否默认")
    private Boolean isDefault;

    @ApiModelProperty("启用")
    private Boolean enabled;

    @ApiModelProperty("备注")
    private String remark;

//////////////////////////////////////////////////////
    @ApiModelProperty(value = "开票抬头")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTypeName;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;
    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    @ApiModelProperty("币种")
    private String custCurr;

    @ApiModelProperty("税号")
    private String taxerNo;

    @ApiModelProperty("法人代表")
    private String legalRepre;

    public String getIsDefaultName(){
        if (isDefault == null){
            return null;
        }
        return isDefault ? "是":"否";
    }
    public String getEnabledName(){
        if (enabled == null){
            return null;
        }
        return enabled ? "启用":"禁用";
    }
}
