package com.elitesland.sale.lm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.*;
import com.elitesland.sale.lm.rpc.param.query.CustAndBelongOuQueryDTO;
import com.elitesland.sale.lm.rpc.param.query.CustBaseQueryDTO;
import com.elitesland.sale.lm.rpc.param.query.CustMessageQueryParam;
import com.elitesland.sale.lm.rpc.param.query.PartnerInvQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = LmCustRpcService.URI)
public interface LmCustRpcService {

    String URI = Application.URI_PREFIX + "/cust";

    @GetMapping("/findCust")
    List<LmCustExtRespDTO> findCust(@RequestParam("custCodeList") List<String> custCodeList);
    @GetMapping("/findCustByCustCode2")
    List<LmCustExtRespDTO> findCustByCustCode2(@RequestParam("custCode2") List<String> custCode2);

    @GetMapping("/getInvCustCode")
    List<String> getInvCustCodes(@RequestParam("userName") Long userId);



    @GetMapping("/findInvCust")
    List<LmSaveCustRespVO> findInvCust(@RequestParam("custCode") String custCode);

    @GetMapping("/getCustSimple")
    CrmCustSimpleVO getCustSimple(@RequestParam("userName") String userName);

    @GetMapping("/getInvCustByUserName")
    List<CustPartnerDTO> getInvCustSimple(@RequestParam("userName") String userName);

    @GetMapping("/getPartnerCust")
    List<CustPartnerDTO> getPartnerCust(@RequestBody PartnerInvQueryDTO partnerInvQueryDTO);


    @GetMapping("/getCustSimpleByUserId")
    CrmCustSimpleVO getCustSimpleByUserId(@RequestParam("userId") Long userId);

    @PostMapping("/getCustAndBelongOu")
    List<CustAndBelongOuDTO> getCustAndBelongOu(@RequestBody CustAndBelongOuQueryDTO custAndBelongOuQueryDTO);


    @GetMapping("/isCancelCustFlag")
    Boolean isCancelCustFlag(@RequestParam("custCode") String custCode);

    @GetMapping("/isDesExists")
    Boolean isDesExists(@RequestParam("desId")Long desId);




    @GetMapping("/getCustAgent")
    List<CustAgentInfoRpcDTO> getCustAgent(@RequestParam("custCodes") List<String> custCodes);



    @PostMapping("/getCustAgentPost")
    List<CustAgentInfoRpcDTO> getCustAgentPost(@RequestBody List<String> custCodes);


    @PostMapping("/getPartnerInvCust")
    List<PartnerInvRpcDTO> getPartnerInvCust(@RequestBody PartnerInvQueryDTO partnerInvQueryDTO);


    @PostMapping("/getCustAndAgent")
    List<CustAndAgentDTO> getCustAndAgent(@RequestBody CustBaseQueryDTO custBaseQueryDTO);

    @GetMapping("/querySalesmanStore")
    List<SalesmanStoreDTO> querySalesmanStore(@RequestParam("empCode") String empCode);

    @PostMapping("/queryType")
    List<CustBaseInfo> queryCustType(@RequestBody List<String> custCodes);

    /**
     * @description: 根据父级客户编码获取子项编码
     * @param:  parentCustCode  父级客户编码
     * @return: List<String> 返回子客户编码
     * @author zhengyue
     * @date: 2023/12/6 13:53
     */
    @GetMapping("/getCustCodeByParent")
    List<String> getCustCodeByParent(@RequestParam("parentCustCode2") String parentCustCode2);

    /** 
     * @description: 根据法人名称或客户号查询关系
     * @param:  legalRepre 法人
     * @return:  List<String> 客户号
     * @author zhengyue
     * @date: 2023/12/7 8:46
     */
    @GetMapping("/getCustCode2ByLegalRepre")
    List<CustLegalRepreRpcDTO> getCustCode2ByLegalRepre(@RequestParam("legalRepre") String legalRepre,
                                                        @RequestParam("custCode2") String custCode2);
    @PostMapping("/getSearchByRegion")
    ApiResult<List<CustCode2BaseDTO>> getSearchByRegion(@RequestBody List<String> regionList);

    @PostMapping("/getMessageInfo")
    List<CustMessageInfoDTO> getMessageInfo(@RequestBody CustMessageQueryParam param);
}
