package com.elitesland.market.dto.sp;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@AllArgsConstructor
public class MktServicePackageElePublishedDTO implements Serializable {
    private static final long serialVersionUID = -588832653341114290L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("服务项名称")
    private String serviceName;

    @ApiModelProperty("菜品规格编码")
    private String itemCode;

    @ApiModelProperty("菜品规格名称")
    private String itemName;

    @ApiModelProperty("平台菜品编码")
    private String platformItemCode;

    @ApiModelProperty("平台菜品名称")
    private String platformItemName;

    @ApiModelProperty("是否必选")
    private Boolean checked;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("服务项图片")
    private String imageUrl;

    @ApiModelProperty("外卖价格/元")
    private BigDecimal price;

    @ApiModelProperty("排序号")
    private Integer sortNo;
}
