package com.elitesland.market.service.fwo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.fwo.MktFwoDTO;
import com.elitesland.market.param.MktFwoKdStatusParamVO;
import com.elitesland.market.param.MktFwoParamVO;
import com.elitesland.market.param.MktOneClickGererateParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktFwoRpcService.PATH)
@Validated
public interface MktFwoRpcService {
    String PATH = "/fwo";

    @PostMapping("/updateKdStatus")
    void updateFwoKdStatus(@RequestBody MktFwoKdStatusParamVO paramVO);

    @PostMapping("/oneClickGererate")
    void oneClickGererate(@RequestBody MktOneClickGererateParamVO paramVO);

    @PostMapping("/deleteFwo")
    void deleteFwo(@RequestBody MktFwoParamVO paramVO);

    @PostMapping("/existFwo")
    ApiResult<Boolean> existFwo(@RequestBody MktFwoParamVO paramVO);

    @PostMapping("/findFwo")
    ApiResult<List<MktFwoDTO>> findFwo(@RequestBody MktFwoParamVO paramVO);
}
