package com.elitesland.market.dto.sp;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@AllArgsConstructor
public class MktServicePackagePosPublishedDTO implements Serializable {
    private static final long serialVersionUID = -3231245502217173915L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("服务项名称")
    private String serviceName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("是否必选")
    private Boolean checked;

    @ApiModelProperty("排序号")
    private String sortNo;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("服务项图片")
    private String imageUrl;

    @ApiModelProperty("平台菜品编码")
    private String platformItemCode;

    @ApiModelProperty("平台菜品名称")
    private String platformItemName;

    @ApiModelProperty("菜品类型")
    private String foodClass;

    @ApiModelProperty("堂食价格/元")
    private BigDecimal price;

    @ApiModelProperty("POS自配送外卖价格")
    private BigDecimal wmPrice;

    private String publishedGoodsId;
}
