package com.elitesland.market.service.sp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.sp.MktServicePackageGroupDTO;
import com.elitesland.market.param.MktServicePackageParamDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktServicePackageGroupRpcService.PATH)
@Validated
public interface MktServicePackageGroupRpcService {
    String PATH = "/sp/group";

    /**
     * 根据服务包ID查询分组信息
     *
     * @param paramVO 参数，包含服务包ID
     * @return 服务包列表
     */
    @PostMapping("/findByPackageId")
    ApiResult<List<MktServicePackageGroupDTO>> findByPackageId(@RequestBody MktServicePackageParamDTO paramVO);
}


