package com.elitesland.market.dto.sp;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MktServicePackageSimpleDTO implements Serializable {
    private static final long serialVersionUID = 7701040619323589991L;

    /**
     * 服务包ID
     */
    private Long id;

    /**
     * 服务包编号
     */
    private String packageNo;

    /**
     * 服务包名称
     */
    private String packageName;

    /**
     * 服务包图片
     */
    private String imageUrl;

    /**
     * 服务包使用次数
     */
    private Long useTotal;

    /**
     * 推荐日期(区间）从
     */
    private LocalDateTime recommendDateFrom;

    /**
     * 推荐日期(区间）至
     */
    private LocalDateTime recommendDateTo;

    /**
     * 推荐日期（天）
     */
    private String recommendDay;

    /**
     * 标签
     */
    private String tag;

    /**
     * 推荐地区
     */
    private String recommendArea;

    /**
     * 推荐类型
     */
    private String recommendType;

    private String itemCate;

    private String brand;

    private BigDecimal maxSaleGrowthRatio;

}
