package com.elitesland.market.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class MktWorkOrderOneClickGererateParamVO implements Serializable {

    private String docType;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("门店ID")
    @NotNull(message = "门店ID不能为空")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("菜品ID")
    @NotNull(message = "菜品ID不能为空")
    private Long recipeId;

    @ApiModelProperty("菜品编码")
    private String recipeCode;

    @ApiModelProperty("菜品名称")
    private String recipeName;

    @ApiModelProperty("开发者ID")
    @NotNull(message = "开发者ID不能为空")
    private Long devId;

    @ApiModelProperty("备注")
    private String remark;
}
