package com.elitesland.market.dto.store;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class MktStoreDTO implements Serializable {
    private static final long serialVersionUID = -7789021846783091057L;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    private String storeName;

    private String storeCode;

    private String storePhoto;

    private String brand;

    private String storeType;

    @ApiModelProperty("是否统管")
    private Boolean unifiedManagementFlag;

}
