package com.elitesland.market.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class MktFreeSampleWorkOrderDSaveParamVO implements Serializable {
    private static final long serialVersionUID = 1528475138858361106L;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("图片")
    private String imageUrl;

    @ApiModelProperty("价格")
    private BigDecimal price;
}
