package com.elitesland.yst.lm.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.lm.order.Application;
import com.elitesland.yst.lm.order.rpc.param.query.ItemQtyQueryDTO;
import com.elitesland.yst.lm.order.rpc.param.resp.ItemQtyRespDTO;
import com.elitesland.yst.lm.order.rpc.param.save.LmSalSoSaveDTO;
import com.elitesland.yst.lm.order.rpc.param.save.LmSalSoSaveRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 订单服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = LmSalSoRpcService.URI)
@Validated
public interface LmSalSoRpcService {
    String URI = "/lm/salSoRpc";

    /**
     * 经销商商城下单-提交订单
     * @param param
     * @return
     */
    @PostMapping("/saveSo")
    ApiResult<List<LmSalSoSaveRespDTO>> saveSo(@RequestBody List<LmSalSoSaveDTO> param);

    @PostMapping("/queryItemQty")
    ApiResult<List<ItemQtyRespDTO>> queryItemQty(@RequestBody List<ItemQtyQueryDTO> param);

    @PostMapping("/queryCustItemQty")
    ApiResult<List<ItemQtyRespDTO>> queryCustItemQty(@RequestBody List<ItemQtyQueryDTO> param);

    /**
     * 查询未清数量-区分排产和现货
     * @param param
     * @return
     */
    @PostMapping("/queryCustItemQtyBySub")
    ApiResult<List<ItemQtyRespDTO>> queryCustItemQtyBySub(@RequestBody List<ItemQtyQueryDTO> param);

}
