package com.elitesland.yst.lm.order.rpc;

import com.elitesland.yst.lm.order.Application;
import com.elitesland.yst.lm.order.rpc.param.query.LmSalDoQueryDTO;
import com.elitesland.yst.lm.order.rpc.param.query.LmUnShippedQueryDTO;
import com.elitesland.yst.lm.order.rpc.param.resp.LmSalDoPerforRespDTO;
import com.elitesland.yst.lm.order.rpc.param.resp.LmSalDoRespDTO;
import com.elitesland.yst.lm.order.rpc.param.resp.LmUnShippedRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/3/25
 */
@FeignClient(name = Application.NAME, path = LmSaleDoRpcService.URI)
@Validated
public interface LmSaleDoRpcService {

    String URI = Application.URI_PREFIX + "/salDo";

    /**
     * 发货单查询
     *
     * @param param
     * @return
     */
    @PostMapping("/query")
    LmSalDoRespDTO querySalDo(@RequestBody LmSalDoQueryDTO param);

    /**
     * 未发货单查询
     *
     * @param param
     * @return
     */
    @PostMapping("/unShipped/query")
    LmUnShippedRespDTO queryUnShippedOrder(@RequestBody LmUnShippedQueryDTO param);

    /**
     * 查询销售业绩统计数据
     * @param dateStr
     * @return
     */
    @PostMapping("/querySalePerfor")
    List<LmSalDoPerforRespDTO> querySalePerfor(@RequestParam("dateStr") String dateStr);
}
