package com.elitesland.yst.lm.order.rpc.param.query;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/3/25
 */
@Data
@ApiModel("发货单查询参数")
public class LmSalDoQueryDTO extends AbstractOrderQueryParam {

    @NotNull(message = "发货日期从不能为空")
    @ApiModelProperty("发货日期从")
    private LocalDateTime dateTimeFrom;

    @NotNull(message = "发货日期至不能为空")
    @ApiModelProperty("发货日期至")
    private LocalDateTime dateTimeTo;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("订单渠道")
    private String channelType;

    @ApiModelProperty("发运基地")
    private String desCode;

    @NotBlank(message = "对账类型不能为空")
    @ApiModelProperty("对账类型：整车-VEHICLE，附件-ACCESSORY_BAG，配件-ACCESSORIES")
    private String docType;
}
