package com.elitesland.yst.lm.order.rpc.param.save;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "LmSalSoSaveDTO", description = "销售订单表")
public class LmSalSoSaveDTO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = -4756672349371703817L;
    private Long secBuId;
    private String docLevel;
    private Long secUserId;
    private Long secOuId;
    private List<String> salSoIds;
    private String intfStatus2;
    private LocalDateTime intfTime2;
    /**
     * 公司ID
     */
    @ApiModelProperty("销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private Boolean autoCheckFlag;
    @ApiModelProperty("销售公司code")
    private String ouCode;
    @ApiModelProperty("销售公司名称")
    private String ouName;
    private String buCode;
    private String buName;
    @ApiModelProperty("区域经理ID")
    private Long agentEmpId2;
    @ApiModelProperty("区域经理")
    private String agentName2;

    @ApiModelProperty("附件销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long accessoryOuId;
    @ApiModelProperty("附件销售公司code")
    private String accessoryOuCode;
    @ApiModelProperty("附件销售公司名称")
    private String accessoryOuName;

    @ApiModelProperty("应支付金额")
    private BigDecimal apAmt;

    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("未结金额")
    private BigDecimal openAmt;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * BUID2
     */
    @ApiModelProperty("BUID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId2;
    /**
     * BUID3
     */
    @ApiModelProperty("BUID3")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId3;
    /**
     * BUID4
     */
    @ApiModelProperty("BUID4")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId4;
    /**
     * BUID5
     */
    @ApiModelProperty("BUID5")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId5;
    /**
     * 单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据编号2
     */
    @ApiModelProperty("单据编号2")
    private String docNo2;




    /**
     * 单据类型 [UDC]SAL:SO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]SAL:SO_TYPE")
    private String docType;
    /**
     * 单据类型2
     */
    @ApiModelProperty("分销渠道")
    private String docType2;
    /**
     * 单据类型3
     */
    @ApiModelProperty("产品组 SAL:SO_TYPE3 整车/配件")
    private String docType3;
    /**
     * 单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS")
    private String docStatus;
    /**
     * 单据状态2
     */
    @ApiModelProperty("单据状态2")
    private String docStatus2;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    /**
     * 审批人ID
     */
    @ApiModelProperty("审批人ID")
    private Long apprUserId;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 下单时间
     */
    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;
    /**
     * 销售场景
     */
    @ApiModelProperty("销售场景")
    private String soScene;
    /**
     * 客户订单号码
     */
    @ApiModelProperty("客户订单号码")
    private String custSoNo;
    /**
     * 客户订单日期
     */
    @ApiModelProperty("客户订单日期")
    private LocalDateTime custSoDate;
    /**
     * 客户联系人 客户跟单人员
     */
    @ApiModelProperty("客户联系人 客户跟单人员")
    private String custContactName;
    /**
     * 客户联系人电话
     */
    @ApiModelProperty("客户联系人电话")
    private String custContactTel;


    private String custCode;


    /**
     * 客户联系人邮箱
     */
    @ApiModelProperty("客户联系人邮箱")
    private String custContactEmail;
    /**
     * 暂挂原因码 [UDC]SAL:SO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]SAL:SO_HOLD_REASON")
    private String holdReasonCode;
    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime invalidDate;
    /**
     * 订单批ID
     */
    @ApiModelProperty("订单批ID")
    private Long soBatchId;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private String crosswhFlag;
    /**
     * 满足策略
     */
    @ApiModelProperty("满足策略")
    private String fulfillPolicy;
    /**
     * 下单渠道
     */

    @ApiModelProperty("下单渠道")
    private String soSource;


    @ApiModelProperty("下单渠道")
    private String soSource2;
    /**
     * 销售区域 [UDC]SAL:SAL_REGION
     */
    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;
    /**
     * 配送区域
     */
    @ApiModelProperty("配送区域")
    private String deliverRegion;
    /**
     * 客户ID 售至
     */
    @ApiModelProperty("客户ID 售至")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;
    /**
     * 客户价格政策组
     */
    @ApiModelProperty("客户价格政策组")
    private String custPriceGroup;
    /**
     * 客户渠道
     */
    @ApiModelProperty("客户渠道")
    private String custChannel;
    /**
     * 开票至客户ID
     */
    @ApiModelProperty("开票公司Id")
    private Long billtoCustId;

    @ApiModelProperty("开票公司Code")
    private String billtoCustCode;

    @ApiModelProperty("开票公司Name")
    private String billtoCustName;
    /**
     * 销售组
     */
    @ApiModelProperty("销售组")
    private String saleGroup;
    /**
     * 业务员员工ID
     */
    @ApiModelProperty("业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    @ApiModelProperty("业务员员工")
    private String agentName;
    @ApiModelProperty("业务员员工")
    private String agentCode ;


    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 是否含税
     */
    @ApiModelProperty("是否含税")
    private String taxInclFlag;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税总金额
     */
    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    /**
     * 未税总金额
     */
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    /**
     * 未税原金额
     */
    @ApiModelProperty("未税原金额")
    private BigDecimal orignNetAmt;
    /**
     * 含税原金额
     */
    @ApiModelProperty("含税原金额")
    private BigDecimal orignAmt;
    /**
     * 未税运费金额
     */
    @ApiModelProperty("未税运费金额")
    private BigDecimal freightFee;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private BigDecimal qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    /**
     * MOQID
     */
    @ApiModelProperty("MOQID")
    private Long moqId;
    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("包装方式 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private BigDecimal demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Long demandAapDays;
    /**
     * 允许部分交货
     */
    @ApiModelProperty("允许部分交货")
    private String allowPartalDeliver;
    /**
     * 允许延期交货
     */
    @ApiModelProperty("允许延期交货")
    private String allowOverdueDeliver;
    /**
     * 允许质检单后补
     */
    @ApiModelProperty("允许质检单后补")
    private String allowPpInv;
    /**
     * 允许超允收期
     */
    @ApiModelProperty("允许超允收期")
    private String allowOverAap;
    /**
     * 允许最大批次数量
     */
    @ApiModelProperty("允许最大批次数量")
    private Long maxLotNum;
    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;
    /**
     * 支付交易ID
     */
    @ApiModelProperty("支付交易ID")
    private Long payTransId;
    /**
     * 付款方式 [UDC]COM:PAY_METHOD
     */
    @ApiModelProperty("付款方式 [UDC]COM:PAY_METHOD")
    private String payMethod;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;
    /**
     * 运输温层 [UDC]INV:TRANSPORT_TEMP
     */
    @ApiModelProperty("运输温层 [UDC]INV:TRANSPORT_TEMP")
    private String transportTemp;
    /**
     * 承运商供应商ID
     */
    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;
    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 从地点
     */
    @ApiModelProperty("从地点")
    private String fromLoc;
    /**
     * 到地点
     */
    @ApiModelProperty("到地点")
    private String toLoc;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    @ApiModelProperty("仓库Code")
    private String  whCode;
    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("附件仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long accessoryWhId;
    @ApiModelProperty("附件仓库Code")
    private String  accessoryWhCode;
    @ApiModelProperty("附件仓库名称")
    private String accessoryWhName;
    /**
     * 限定1
     */
    @ApiModelProperty("限定1")
    private String deter1;
    /**
     * 限定2
     */
    @ApiModelProperty("功能区")
    private String deter2;
    /**
     * 限定3
     */
    @ApiModelProperty("限定3")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 发货仓库联系人
     */
    @ApiModelProperty("发货仓库联系人")
    private String whContactName;
    /**
     * 发货仓库联系人电话
     */
    @ApiModelProperty("发货仓库联系人电话")
    private String whContactTel;
    /**
     * 发货仓库联系人邮箱
     */
    @ApiModelProperty("发货仓库联系人邮箱")
    private String whContactEmail;
    /**
     * 要求日期
     */
    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;
    /**
     * 计划出库日期
     */
    @ApiModelProperty("计划出库日期")
    private LocalDateTime planShipDate;
    /**
     * 承诺交货日期
     */
    @ApiModelProperty("承诺交货日期")
    private LocalDateTime promiseDeliverDate;
    /**
     * 通知仓库发货时间
     */
    @ApiModelProperty("通知仓库发货时间")
    private LocalDateTime commandShipTime;
    /**
     * 拣货时间
     */
    @ApiModelProperty("拣货时间")
    private LocalDateTime pickTime;
    /**
     * 出库确认时间
     */
    @ApiModelProperty("出库确认时间")
    private LocalDateTime shipConfirmTime;
    /**
     * 配送送达时间
     */
    @ApiModelProperty("配送送达时间")
    private LocalDateTime deliveredTime;
    /**
     * 确认收货时间
     */
    @ApiModelProperty("确认收货时间")
    private LocalDateTime recvConfirmTime;
    /**
     * 发货指令
     */
    @ApiModelProperty("交货指令1")
    private String deliverInstruct;
    /**
     * 发货指令2
     */
    @ApiModelProperty("交货指令2")
    private String deliverInstruc2;
    /**
     * 配送门店类型
     */
    @ApiModelProperty("配送门店类型")
    private String deliverStoreType;
    /**
     * 配送状态
     */
    @ApiModelProperty("配送状态")
    private String deliverStatus;
    /**
     * 配送方式 [UDC]SAL:SO_DELIVER_METHOD
     */
    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    /**
     * 收方限定1
     */
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;
    /**
     * 收方限定3
     */
    @ApiModelProperty("收方限定3")
    private String recvDeter3;
    /**
     * 收方限定4
     */
    @ApiModelProperty("收方限定4")
    private String recvDeter4;
    /**
     * 收货地址号
     */
    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;
    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;
    /**
     * 收货联系人邮箱
     */
    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;
    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省
     */
    @ApiModelProperty("收货省")
    private String recvProvince;
    /**
     * 收货市
     */
    @ApiModelProperty("收货市")
    private String recvCity;
    /**
     * 收货区县
     */
    @ApiModelProperty("收货区县")
    private String recvCounty;
    /**
     * 收货乡镇街道
     */
    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;
    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
    /**
     * 退货原因码 [UDC]SAL:SO_RETURN_REASON
     */
    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    private String returnReasonCode;
    /**
     * 退货状态
     */
    @ApiModelProperty("退货状态")
    private String returnStatus;
    /**
     * 退货申请时间
     */
    @ApiModelProperty("退货申请时间")
    private LocalDateTime returnApplyTime;
    /**
     * 退货批准时间
     */
    @ApiModelProperty("退货批准时间")
    private LocalDateTime returnApprTime;


    /**
     * 未税折扣金额
     */
    @ApiModelProperty("未税折扣金额")
    private BigDecimal discNetAmt;
    /**
     * 关单原因码 [UDC]SAL:SO_CLOSE_REASON
     */
    @ApiModelProperty("关单原因码 [UDC]SAL:SO_CLOSE_REASON")
    private String closeReasonCode;
    /**
     * 关单人ID
     */
    @ApiModelProperty("关单人ID")
    @JsonSerialize
    private Long closeUserId;
    /**
     * 含税发运总金额
     */
    @ApiModelProperty("含税发运总金额")
    private BigDecimal shippedAmt;
    /**
     * 未税发运总金额
     */
    @ApiModelProperty("未税发运总金额")
    private BigDecimal shippedNetAmt;
    /**
     * 是否实物退回
     */
    @ApiModelProperty("是否实物退回")
    private String returnMatFlag;
    /**
     * 是否有退货合同
     */
    @ApiModelProperty("是否有退货合同")
    private String returnContractFlag;
    @ApiModelProperty("是否需要验收")
    private String needExamFlag;

    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("合同id")
    private String contractId;
    @ApiModelProperty("合同名称")
    private String contractName;


    /**
     * 是否就地销毁
     */
    @ApiModelProperty("是否就地销毁")
    private String otsDestroyFlag;
    /**
     * 含税退货总金额
     */
    @ApiModelProperty("含税退货总金额")
    private BigDecimal returnAmt;
    /**
     * 未税退货总金额
     */
    @ApiModelProperty("未税退货总金额")
    private BigDecimal returnNetAmt;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因 [UDC]SAL:SO_CANCEL_REASON
     */
    @ApiModelProperty("取消原因 [UDC]SAL:SO_CANCEL_REASON")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 退款状态
     */
    @ApiModelProperty("退款状态")
    private String refundStatus;
    /**
     * 退款时间
     */
    @ApiModelProperty("退款时间")
    private LocalDateTime refundTime;
    /**
     * 退款金额
     */
    @ApiModelProperty("退款金额")
    private BigDecimal refundAmt;
    /**
     * 折扣类型
     */
    @ApiModelProperty("折扣类型")
    private String discType;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 含税折扣金额
     */
    @ApiModelProperty("含税折扣金额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private String invDate;
    /**
     * 产品线ID
     */
    @ApiModelProperty("产品线ID")
    private Long plId;
    /**
     * 供应商ID 用于代发
     */
    @ApiModelProperty("供应商ID 用于代发")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 完成率
     */
    @ApiModelProperty("完成率")
    private BigDecimal finishRate;
    /**
     * 模板ID
     */
    @ApiModelProperty("模板ID")
    private Long tsoId;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("来源单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String rootDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    private Long relateId;
    /**
     * 未税原总金额
     */
    @ApiModelProperty("未税原总金额")
    private BigDecimal oringNetAmt;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;
    /**
     * 外部单据公司
     */
    @ApiModelProperty("外部单据公司")
    private String outerOu;
    /**
     * 外部单据类型
     */
    @ApiModelProperty("外部单据类型")
    private String outerType;
    /**
     * 外部单据编号
     */
    @ApiModelProperty("外部单据编号")
    private String outerNo;
    /**
     * 备注2
     */
    @ApiModelProperty("备注2")
    private String remark2;

    @ApiModelProperty("订单备注")
    private String remark;
    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    private LocalDateTime confirmedTime;
    /**
     * 是否走接口
     */
    @ApiModelProperty("是否走接口")
    private String intfFlag;
    /**
     * 附件code 数组
     */
    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;

    /**
     * 订单明细
     */
    @ApiModelProperty("订单明细")
    private List<LmSalSoDSaveDTO> salSoDSaveVOList;

    @ApiModelProperty("制单人电话")
    private String creatorTel;

    /**
     * 排期类型(订单明细中参数，订单更新数据业务需求)
     */
    @ApiModelProperty("排期类型")
    private String scheduleType;

    /**
     * 发货单明细关联销售订单明细行号集合
     */
    @ApiModelProperty("发货单明细关联销售订单明细行号集合")
    private List<BigDecimal> relateDocLineNos;

    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;
    /**
     * 代下单类型
     */
    @ApiModelProperty("代下单类型[UDC]SAL:AGENT_TYPE")
    private String agentType;

    /**
     * 订单创建人
     */
    @ApiModelProperty("订单创建人")
    private String es1;

    /**
     * 处理人
     */
    @ApiModelProperty("处理人")
    private String es2;

    /**
     * 跟进人
     */
    @ApiModelProperty("跟进人")
    private String es3;

    /**
     * 拒绝退货退款原因
     */
    @ApiModelProperty("拒绝退货退款原因")
    private String reason;


    @ApiModelProperty("订单类型 标准/免费/POD/免费捐赠 [UDC]SAL:SO_TYPE4")
    private String docType4;

    @ApiModelProperty("单据类型5 [UDC]SAL:SO_TYPE5")
    private String docType5;

    @ApiModelProperty("出库公司ID")
    private Long ou2Id;
    @ApiModelProperty("出库公司Code")
    private String ou2Code;
    @ApiModelProperty("出库公司名称")
    private String ou2Name;
    @ApiModelProperty("收货人证件号")
    private String recvIdenNo;

    @ApiModelProperty("运单号")
    private String trackNo;

    @ApiModelProperty("开票类型 [UDC]COM:INV_TYPE")
    private String invType;

    @ApiModelProperty("返利客户ID")
    private Long rebateCustId;

    @ApiModelProperty("发票号码")
    private String invNo ;

    @ApiModelProperty("第二套外部单据公司 [UDC]COM:OUTER_SYS_TYPE")
    private String outerOu2;

    @ApiModelProperty("第二套外部单据类型 [UDC]COM:OUTER_SYS_TYPE")
    private String outerType2;

    @ApiModelProperty("第二套外部单据编号 [UDC]COM:OUTER_SYS_TYPE")
    private String outerNo2;
    @ApiModelProperty("省区经理")
    private String provincialManager;

    @ApiModelProperty("销售总监")
    private String salesDirector;
    @ApiModelProperty("发运地")
    private String desCode;
    @ApiModelProperty("发运基地ID")
    private Long desId;

    @ApiModelProperty("定价日期")
    private LocalDateTime priceDate;

    @ApiModelProperty("所属客服")
    private String customerService;

    /**
     * 发运地名称
     */
    @ApiModelProperty("发运地名称")
    private String desName;

    /**
     * 交易路径ID
     */
    @ApiModelProperty("交易路径ID")
    private String transactionPathId;

    /**
     * 开票抬头
     */
    @ApiModelProperty("开票抬头")
    private String invTitle;

    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxRegNo;

    /**
     * 开票地址
     */
    @ApiModelProperty("开票地址")
    private String invAddress;

    /**
     * 开票电话
     */
    @ApiModelProperty("开票电话")
    private String invTel;

    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String invBankName;

    /**
     * 银行账户
     */
    @ApiModelProperty("银行账户")
    private String invBankAcc;

    /**
     * 开票联系人
     */
    @ApiModelProperty("开票联系人")
    private String invPicName;

    /**
     * 开票联系人电话
     */
    @ApiModelProperty("开票联系人电话")
    private String invPicPhone;
    /**
     * 收货客户号
     */
    @ApiModelProperty("收货客户号")
    private String  recvCustCode2;
    /**
     * 收货客户类型
     */
    @ApiModelProperty("收货客户类型")
    private String recvCustType;
    /**
     * 返利客户名称
     */
    @ApiModelProperty("返利客户名称")
    private String  rebateCustName;
    /**
     * 返利客户编码
     */
    @ApiModelProperty("返利客户编码")
    private String  rebateCustCode;
    /**
     * 外部系统类型
     */
    @ApiModelProperty("外部系统类型")
    private String outerSysType;
    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String custType2;

    private String province;
    @ApiModelProperty("贸易公司id")
    private Long tradeOuId;

    @ApiModelProperty("贸易公司code")
    private String tradeOuCode;

    @ApiModelProperty("贸易公司name")
    private String tradeOuName;
    @ApiModelProperty("客户号")
    private String custCode2;

    private String accessoryDeter2;

    private String accessoryDeter2Name;
    @ApiModelProperty("所属客服编码")
    private String customerServiceCode;
    private String salesDirectorCode;
    private String provincialManagerCode;
    @ApiModelProperty("返利客户号")
    private String  rebateCustCode2;
    @ApiModelProperty("收货客户名称")
    private String recvCustName;

    @ApiModelProperty("收货客户编码")
    private String recvCustCode;
    private String agentCode2 ;
    @ApiModelProperty("下单客户类型")
    private String custType;

    @ApiModelProperty("业务员path信息")
    private String salesmanPath;

    @ApiModelProperty("业务员pathCode信息")
    private String salesmanPathCode;

}
